; This code is responsible for the dust cycling output in the two deserts. Then the data is then visualized based on origin
begin

  geof1  = addfile("/home/user/chensy3/data/zhangyue/WPSV391_2020-03/geo_em.d01.nc","r")
  lat2d = geof1->XLAT_M(0,:,:)
  lon2d = geof1->XLONG_M(0,:,:)
  lat1d = lat2d(:,0)
  lon1d = lon2d(0,:)    


;***********Reading the dust emission, loading and deposition
path="/home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/ETL_data/dust_emission/2020-03/"

filename="wrfout_dustemission_wind10_2020_03_1*.nc"
outfiles=systemfunc("ls " +path+filename)
f=addfiles(outfiles+".nc","r")

ListSetType(f,"join")
var = wrf_user_getvar(f(:),"DE",-1)*1.
printVarSummary(var)



;do i=0,5
;    var_avg=var(i,:,:)
    var!1="lat2d"
    var!2="lon2d"
    var2 = rcm2rgrid_Wrap(lat2d, lon2d, var, lat1d, lon1d, 0)
    var2!1="lat"
    var2!2="lon"
    var3=var2(:,{13:51},{78:127})
    
    lon_def=fspan(78, 127, 49)
    lat_def=fspan(13,51,38)
    lon_var=var3&lon
    lat_var=var3&lat
    var_end=linint2_Wrap(lon_var, lat_var, var3, True, lon_def, lat_def, 0)
    var_end!1="lat"
    var_end!2="lon"
    var_end&lon@units="degrees_east"
    var_end&lat@units="degrees_north"
    printVarSummary(var_end)
;end do

    var_Tak=var_end(:,{36:43},{78:94})
    var_Gob=var_end(:,{38:46},{96:110})

    var_Tak_avg=dim_avg_n_Wrap(var_Tak, (/1,2/))
    var_Gob_avg=dim_avg_n_Wrap(var_Gob, (/1,2/))
    var_avg=dim_avg_n_Wrap(var_end, (/1,2/))

    print(var_Tak_avg);*0.000001
    print("tak over**********")

    print(var_Gob_avg);*0.000001
    print("gob over**********")

    print(var_avg);*0.000001
    print("avg over**********")
end